### v-1.0.5 | []()

#### feat: data importation 
Introduced a new data importation feature for categories and products. The `CategoryImport` class implements the `ToModel` interface to handle category imports from CSV files, allowing for easy addition of categories with fields like name, parent ID, commission, order index, and image. The import functionality is integrated into the admin settings page, enabling administrators to upload CSV files for importing data.


### v-1.0.4 | [5636e26](https://github.com/alireza-hadizadeh/e-commerce-v2/commit/5636e26e9b553878f51dab13db0c00c6d25fa5f4)

#### Add Persian datepicker & update product schema
```sql
ALTER TABLE `products` 
CHANGE COLUMN `price` `price` BIGINT(15) UNSIGNED NULL DEFAULT NULL ,
CHANGE COLUMN `inventory` `inventory` INT UNSIGNED NULL DEFAULT '0' ,
CHANGE COLUMN `discount_price` `discount_price` BIGINT(15) UNSIGNED NULL DEFAULT NULL ;

ALTER TABLE `product_inventories` 
CHANGE COLUMN `price` `price` BIGINT(15) UNSIGNED NULL DEFAULT NULL ,
CHANGE COLUMN `inventory` `inventory` INT UNSIGNED NULL DEFAULT '0' ;


```
Introduced a reusable Persian datepicker Blade component and integrated it into coupon forms and template pages. Updated product and product inventory migrations to use unsigned BIGINT for price columns and unsigned INT for inventory. Enhanced order listing for shop users, improved Farsi translations, and updated product details and admin order views to display inventory and supplier information. Added required assets for Persian datepicker and related scripts.

### v-1.0.3 | [5636e26](https://github.com/alireza-hadizadeh/e-commerce-v2/commit/5636e26e9b553878f51dab13db0c00c6d25fa5f4)

#### Add bulk add-to-cart for office equipment products
Introduced OfficeEquipmentProductAddToCartAction to handle adding all, equipment, or consumable products from a group to the cart. Updated the office equipment products page to provide form buttons for these actions and display success/error alerts. Added related Farsi translations and registered the new POST route.


### v-1.0.3 | [2f2763f](https://github.com/alireza-hadizadeh/e-commerce-v2/commit/2f2763f42bde4947fe6c3b1604af8f531816c8c2)

#### Add length, width, and height fields to products
- Added `length`, `width`, and `height` fields to the `products` table.
  ```sql
    ALTER TABLE `products`
        ADD COLUMN `length` VARCHAR(255) NULL DEFAULT '0' AFTER `weight`,
        ADD COLUMN `width`  VARCHAR(255) NULL DEFAULT '0' AFTER `length`,
        ADD COLUMN `height` VARCHAR(255) NULL DEFAULT '0' AFTER `width`;
  ```

Introduces 'length', 'width', and 'height' fields to the products table, model, request validation, service, and product form UI. Updates migration, translations, and product listing views to support and display these new attributes.


### v-1.0.2 | [a8a18c4](https://github.com/alireza-hadizadeh/e-commerce-v2/commit/a8a18c4e42180dfc49ae12d8e5376e8b4ac47542)

#### Add consumable field to products and update UI
- Added `consumable` field to the `products` table.
  ```sql
    ALTER TABLE `products` 
    ADD COLUMN `consumable` TINYINT(1) NULL DEFAULT '0' AFTER `second_hand`;
  ```

Introduces a new 'consumable' boolean field to the products table and model, updates migration, and adds related UI elements and translations. Product forms and office equipment product listings now support and display the consumable status. Also includes minor CSS and layout improvements, and cleans up the page template.
