<?php

namespace App\Cache;

use App\Models\Category;
use Illuminate\Support\Collection;
use App\Services\Models\CategoryService;

class CategoryTreeCache extends BaseCacheable
{
    public function key(): string
    {
        return 'category_tree';
    }

    public function ttl(): ?int
    {
        return null;
    }

    public function forever(): bool
    {
        return true;
    }

    public function tags(): array
    {
        return ['categories'];
    }

    public function resolve(): Collection|array
    {
        return CategoryService::buildTree();
    }
}
