<?php

use App\Models\Option;
use Illuminate\Support\Str;


if (!function_exists('removeNullValues')) {
    function removeNullValues(array $array): array
    {
        return array_filter($array, function ($value) {
            return !is_null($value);
        });
    }
}

if (!function_exists('getDefaultUserImage')) {
    function getDefaultUserImage()
    {
        return "/assets/themes/blesser/images/user.png";
    }
}
if (!function_exists('is_string_link')) {
    function is_string_link($url_string)
    {
        /**
         * Checks if a string is a valid URL in PHP or starts with "site_options/".
         *
         * @param string $url_string The string to check.
         * @return bool True if the string is a valid URL or starts with "site_options/", false otherwise.
         */
        return (bool)filter_var($url_string, FILTER_VALIDATE_URL) || str_starts_with($url_string, 'site_options/');
    }
}

if (! function_exists('options')) {
    function options($key = null)
    {
        if ($key) {
            return Option::getByKey($key);
        }

        return app('web_options');
    }
}
if (! function_exists('generateSlug')) {
    function generateSlug($model, string $title): string
    {
        $baseSlug = Str::slug($title);
        $slugCount = $model::where('slug', 'like', "$baseSlug%")->count();

        return $slugCount === 0 ? $baseSlug : $baseSlug . '-' . ($slugCount + 1);
    }
}
if (! function_exists('getCurrency')) {
    function getCurrency()
    {
        return options('site_currency')->first()->value ?? 'تومان';
    }
}

if (! function_exists('getSiteLogo')) {
    function getSiteLogo()
    {
        return options('site_logo')->first()->value ?? config('app.logo') ?? env('APP_LOGO') ?? '/assets/themes/blesser/images/logo.png';
    }
}
if (! function_exists('getSiteName')) {
    function getSiteName()
    {
        return options('site_name')->first()->value ?? config('app.name') ?? env('APP_NAME') ?? 'Site Name';
    }
}
if (! function_exists('getTinyMCELink')) {
    function getTinyMCELink()
    {
        return 'https://cdn.tiny.cloud/1/wvj96glw8ghg85zll4jok7bknhwi4lropfzu5qvuw42jgrlg/tinymce/6/plugins.min.js';
    }
}
if (! function_exists('tinyMceScript')) {
    function tinyMceScript()

    {
        return '<script src="' . getTinyMCELink() . '" referrerpolicy="origin"></script>';
    }
}
