<?php

namespace App\Http\Controllers\Admin\Delivery;

use App\Http\Controllers\Controller;
use App\Models\DeliveryItem;
use Illuminate\Http\Request;

class DeliveryItemController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
    {
        $items = DeliveryItem::all();
        return view('pages.admin.deliveries.items.index', compact('items'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Request $request, DeliveryItem $delivery_item)
    {
        return view('pages.admin.deliveries.items.edit', compact('delivery_item'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, DeliveryItem $delivery_item)
    {
        $validated = $request->validate([
            'delivery_id' => 'required|exists:deliveries,id',
            'order_item_id' => 'required|exists:order_items,id',
        ]);
        $delivery_item->update($validated);
        return redirect()->route('admin.delivery-items.index')->with('success', __('Delivery item updated successfully'));
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
