<?php

namespace App\Http\Controllers\Admin\Delivery;

use Illuminate\Http\Request;
use App\Models\DeliveryProvider;
use App\Http\Controllers\Controller;

class DeliveryProviderController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $providers = DeliveryProvider::all();
        return view('pages.admin.delivery.provider.index', compact('providers'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('pages.admin.delivery.provider.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $validated = $request->validate([
            'name' => 'required|string|max:255',
            'code' => 'required|string|max:50|unique:delivery_providers,code',
            'contact_phone' => 'nullable|string|max:20',
            'contact_email' => 'nullable|email|max:255',
            'notes' => 'nullable|string',
        ]);

        DeliveryProvider::create($validated);

        return redirect()->route('admin.delivery.providers.index')->sweetalert()->success(__('Delivery provider created successfully.'));
    }


    /**
     * Show the form for editing the specified resource.
     */
    public function edit(DeliveryProvider $provider)
    {
        return view('pages.admin.delivery.provider.edit', compact('provider'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, DeliveryProvider $provider)
    {
        $validated = $request->validate([
            'name' => 'required|string|max:255',
            'code' => 'required|string|max:50|unique:delivery_providers,code,' . $provider->id,
            'contact_phone' => 'nullable|string|max:20',
            'contact_email' => 'nullable|email|max:255',
            'notes' => 'nullable|string',
        ]);

        $provider->update($validated);

        return redirect()->route('admin.delivery.providers.index')->sweetalert()->success(__('Delivery provider updated successfully.'));
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(DeliveryProvider $provider)
    {
        $provider->delete();

        return redirect()->route('admin.delivery.providers.index')->sweetalert()->success(__('Delivery provider deleted successfully.'));
    }
}
