<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\OfficeEquipmentGroup;

class OfficeEquipmentGroupController extends Controller
{
    public function index()
    {
        $groups = OfficeEquipmentGroup::all();
        return view('pages.admin.office-equipment-groups.index', compact('groups'));
    }

    public function create()
    {
        return view('pages.admin.office-equipment-groups.create');
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'name' => 'required|string|max:255',
            'description' => 'nullable|string',
        ]);
        $validated['created_by'] = auth()->id();

        OfficeEquipmentGroup::create($validated);

        return redirect()->route('admin.office-equipment-groups.index')->with('success', __('Office Equipment Group created successfully.'));
    }

    public function show(OfficeEquipmentGroup $officeEquipmentGroup)
    {
        return view('pages.admin.office-equipment-groups.show', compact('officeEquipmentGroup'));
    }

    public function edit(OfficeEquipmentGroup $officeEquipmentGroup)
    {
        return view('pages.admin.office-equipment-groups.edit', compact('officeEquipmentGroup'));
    }

    public function update(Request $request, OfficeEquipmentGroup $officeEquipmentGroup)
    {

        $validated = $request->validate([
            'name' => 'required|string|max:255',
            'description' => 'nullable|string',
        ]);
        $validated['created_by'] = auth()->id();

        $officeEquipmentGroup->update($validated);


        return redirect()->route('admin.office-equipment-groups.index')->with('success', 'Office Equipment Group updated successfully.');
    }

    public function destroy(OfficeEquipmentGroup $officeEquipmentGroup)
    {
        $officeEquipmentGroup->delete();
        return redirect()->route('admin.office-equipment-groups.index')->with('success', 'Office Equipment Group deleted successfully.');
    }
}
