<?php

namespace App\Http\Controllers\Admin;

use App\Models\Option;
use Illuminate\Support\Str;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Response;

class OptionController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function panel(Request $request)
    {
        $options = Option::all();

        if ($request->ajax() || (isset($request->ajax) && $request->ajax == true)) {
            return Response::success(['options' => $options]);
        }
        return view('pages.admin.option.panel', compact('options'));
    }
    /**
     * Display a listing of the resource.
     */
    public function groupIndex()
    {
        $groups = Option::select('group')->distinct()->get();
        return view('pages.admin.option.group_index', compact('groups'));
    }
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
    {
        $siteOptions = $request->group
            ? Option::where('group', $request->group)->get()
            : Option::where('group', null)->get();

        return view('pages.admin.option.index', compact('siteOptions'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('pages.admin.option.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $json_data = [];

        $validated = $request->validate([
            'group' => 'nullable',
            'key' => 'required|string|max:255',
            'value' => 'required_without:value_file',
            'data' => 'nullable',
            'value_file' => 'required_without:value',
        ]);

        if (isset($request->data) && $request->data != null) {
            foreach ($request->data as $key => $value) {
                $json_data[$value['key']] = $value['value'];
            }
            $validated['data'] = json_encode($json_data);
        }

        $validated['user_id'] = auth()->user()->id;
        $validated['env'] = $request->env ?? 'web';

        if ($request->hasFile('value_file')) {
            $validated['value'] = $request->file('value_file')->store('site_options', 'public_upload');
        }

        Option::create($validated);

        return redirect()->route('admin.option.index', ['group' => $request->group])
            ->with(__('success'), __('Site Option created successfully.'));
    }

    /**
     * Display the specified resource.
     */
    public function show($id)
    {
        $siteOption = Option::findOrFail($id);
        return view('pages.admin.option.show', compact('siteOption'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit($id)
    {
        $siteOption = Option::findOrFail($id);
        return view('pages.admin.option.edit', compact('siteOption'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, $id)
    {
        $validated = $request->validate([
            'key' => 'required|string|max:255,' . $id,
            'data' => 'nullable',

            'value' => 'required_without:value_file',
            'value_file' => 'required_without:value',
        ]);

        if ($request->hasFile('value_file')) {
            $validated['value'] = $request->file('value_file')->store('site_options', 'public_upload');
        }

        if (isset($request->data) && $request->data != null) {
            foreach ($request->data as $key => $value) {
                $json_data[$value['key']] = $value['value'];
            }
            $validated['data'] = json_encode($json_data);
        }

        $siteOption = Option::findOrFail($id);
        $group = $siteOption->group;
        $siteOption->update($validated);

        return redirect()->route('admin.option.index', ['group' => $group])
            ->with(__('success'), __('Site Option updated successfully.'));
    }

    public function updateAll(Request $request)
    {
        $submittedOptions = $request->input('options', []);

        foreach ($submittedOptions as $id => $optionData) {
            // Validate input structure
            $key = $optionData['key'] ?? null;
            $value = $optionData['value'] ?? null;
            $data = $optionData['data'] ?? null;

            // Find and update the Option model
            $option = Option::find($id);
            if ($option) {
                $option->key = $key;
                $option->value = $value;

                // Encode dynamic JSON structure only if it exists
                $option->data = $data ? json_encode($data, JSON_UNESCAPED_UNICODE) : null;

                $option->save();
            }
        }

        return redirect()->back()->with('success', __('All options updated successfully!'));
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id)
    {
        $siteOption = Option::findOrFail($id);
        $group = $siteOption->group;
        $siteOption->delete();

        return redirect()->route('admin.option.index', ['group' => $group])
            ->with(__('success'), __('Site Option deleted successfully.'));
    }
}
