<?php

namespace App\Http\Controllers\Admin\Settings;

use Illuminate\Http\Request;
use App\Imports\ProductImport;
use App\Imports\CategoryImport;
use App\Http\Controllers\Controller;
use Maatwebsite\Excel\Facades\Excel;

class ImportController extends Controller
{
    public function import(Request $request)
    {
        $request->validate([
            'file' => 'required|mimes:xlsx,xls,csv|max:10240', // max 10MB
        ]);

        try {
            switch ($request->type) {
                case 'category':
                    Excel::import(new CategoryImport, $request->file('file'));
                    break;
                case 'product':
                    Excel::import(new ProductImport, $request->file('file'));
                    break;
                default:
                    return redirect()->back()->with('error', 'خطا در وارد کردن فایل: ');
                    break;
            }
            return redirect()->back()->with('success', 'فایل با موفقیت وارد شد.');
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'خطا در وارد کردن فایل: ' . $e->getMessage());
        }
    }
}
