<?php

namespace App\Http\Controllers\Admin\Settings\Ui;

use App\Models\Option;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class FooterSectionController extends Controller
{
    public function index()
    {
        $items = Option::where('env', 'web')
            ->where('group', 'footer-first-section')
            ->get();

        return view('pages.admin.settings.ui.footer-sections.index', compact('items'));
    }

    public function edit(Option $footerSection)
    {
        return view('pages.admin.settings.ui.footer-sections.edit', compact('footerSection'));
    }

    public function update(Request $request, Option $footerSection)
    {
        $validated = $request->validate([
            'value' => 'required|string|max:255',
            'data' => 'required|array',
            'data.links' => 'required|array',
            'data.links.*.label' => 'required',
            'data.links.*.url' => 'required',
        ]);

        $footerSection->update([
            'value' => $validated['value'],
            'data' => json_encode($validated['data']),
        ]);

        return redirect()->route('admin.settings.ui.footer-sections.index')->with('success', 'Section updated');
    }
}
