<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Route;

class LoginController extends Controller
{
    public function __invoke(Request $request)
    {
        $request->validate(
            [
                'identifier' => 'required',
                'password' => 'required',
            ]
        );

        $user = User::where('username', $request->identifier)->orWhere('email', $request->identifier)->orWhere('phone', $request->identifier)->first();

        if ($user == null) {
            return back()->with('status', __('auth.not_found'));
        }
        if (! Hash::check($request->password, $user->password)) {
            return back()->with('status', __('auth.failed'));
        }

        Auth::login($user, $request->remember);

        if ($request->headedTo != null) {
            return redirect($request->headedTo);
        }

        if (Route::is('admin.login.form')) {
            return redirect()->route('admin.dashboard');
        } else {
            return redirect()->route('home');
        }
    }
}
