<?php

namespace App\Livewire\Admin;

use App\Models\Product;
use Livewire\Component;
use App\Models\OfficeEquipmentGroup;

class OfficeEquipmentGroupsDetails extends Component
{
    public OfficeEquipmentGroup $group;
    public string $search = '';
    public ?int $selectedProductId = null;
    public int $quantity = 1;

    public function mount($groupId)
    {
        $this->group = OfficeEquipmentGroup::findOrFail($groupId);
    }

    public function getFilteredProductsProperty()
    {
        return Product::where('title', 'like', "%{$this->search}%")
            ->whereNotIn('id', $this->group->products->pluck('id'))
            ->limit(10)
            ->get();
    }

    public function addProduct()
    {
        if ($this->selectedProductId && $this->quantity > 0) {
            $this->group->products()->attach($this->selectedProductId, ['quantity' => $this->quantity]);
            $this->reset(['selectedProductId', 'quantity', 'search']);
            $this->group->refresh();
        }
    }

    public function removeProduct($productId)
    {
        $this->group->products()->detach($productId);
        $this->group->refresh();
    }

    public function render()
    {
        return view('livewire.admin.office-equipment-groups-details', [
            'groupProducts' => $this->group->products,
            'filteredProducts' => $this->filteredProducts,
        ]);
    }
}
