<?php

namespace App\Livewire\Auth;

use App\Models\User;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Session;
use Livewire\Attributes\Validate;
use Livewire\Component;

class LoginPassword extends Component
{
    #[Validate('required')]
    public $password;

    public function handle()
    {
        $this->validate();
        $identifier = Session::get('login_identifier');

        if ($identifier == null) {
            $this->addError('error', __('something went wrong! please refresh the page'));

            return;
        }

        $user = User::where('username', $identifier)->orWhere('email', $identifier)->orWhere('phone', $identifier)->first();

        if ($user == null) {
            $this->addError('error', __('user dose not exists'));

            return;
        }

        if (! Hash::check($this->password, $user->password)) {
            $this->addError('error', __('credential dose not match'));

            return;
        }

        Auth::login($user);

        if (Session::exists('headedTo') && Session::get('headedTo') != null) {
            return redirect(Session::get('headedTo'));
        }

        return redirect()->route('user.dashboard');
    }

    public function render()
    {
        return view('livewire.auth.login-password');
    }
}
