<?php

namespace App\Livewire\Forms;

use App\Models\Address;
use Livewire\Attributes\Validate;
use Livewire\Component;

class AddressForm extends Component
{
    public $model = null;

    public ?string $actionName = null;

    public string $action;

    public $user_id;

    #[Validate('required')]
    public string $address;

    #[Validate('required')]
    public string $province;

    #[Validate('required')]
    public string $city;

    #[Validate('nullable')]
    public ?string $neighborhood = null;

    #[Validate('required')]
    public string $plaque;

    #[Validate('required')]
    public string $unit;

    #[Validate('required')]
    public string $zip_code;

    #[Validate('nullable')]
    public ?string $latitude = null;

    #[Validate('nullable')]
    public ?string $longitude = null;

    public bool $owner_is_receiver = true;

    #[Validate('required_if:owner_is_receiver,false')]
    public ?string $receiver_name = null;

    #[Validate('required_if:owner_is_receiver,false')]
    public ?string $receiver_phone = null;

    public function mount(): void
    {
        if (!is_null($this->model)) {
            $this->model = Address::find($this->model);
            $this->address = $this->model->address;
            $this->province = $this->model->province;
            $this->city = $this->model->city;
            $this->neighborhood = $this->model->neighborhood;
            $this->plaque = $this->model->plaque;
            $this->unit = $this->model->unit;
            $this->zip_code = $this->model->zip_code;
            $this->latitude = $this->model->latitude;
            $this->longitude = $this->model->longitude;
            $this->owner_is_receiver = $this->model->owner_is_receiver;
            $this->receiver_name = $this->model->receiver_name;
            $this->receiver_phone = $this->model->receiver_phone;
        }
    }

    public function save(): void
    {
        $validated = $this->validate();

        if (is_null($this->model)) {
            Address::create([
                    'user_id' => auth()->user()->id
                ] + $validated);
            session()->flash('success', __('new address created successfully.'));
        } else {
            $this->model->update($validated);
            session()->flash('success', __('address updated successfully.'));
        }

        $this->dispatch('new-address-created');
    }

    public function render()
    {
        return view('livewire.forms.address-form');
    }
}
