<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Brand extends Model
{
    protected $fillable = [
        'name',
        'slug',
        'description',
        'logo',
        'category_id',
    ];

    public function category(): BelongsTo
    {
        return $this->belongsTo(related: Category::class);
    }

}
