<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Category extends Model
{
    protected $fillable = [
        'name',
        'parent_id',
        'commission',
        'order_index',
        'image',
    ];

    /**
     * The part below is for this model relationships
     */
    public function parent(): BelongsTo
    {
        return $this->belongsTo(Category::class, 'parent_id');
    }

    public function children(): HasMany
    {
        return $this->hasMany(Category::class, 'parent_id');
    }

    public function attributes(): HasMany
    {
        return $this->hasMany(CategoryAttribute::class);
    }

    /**
     * The above is for this model relationships
     */
    protected static function booted()
    {
        //  for default ordering
        static::addGlobalScope('order', function ($builder) {
            $builder->orderBy('order_index');
        });
    }
    
}
