<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\MorphTo;
use Illuminate\Database\Eloquent\SoftDeletes;

class OrderItem extends Model
{
    use SoftDeletes;

    protected $fillable = [
        'order_id',
        'item_type',
        'item_id',
        'inventory_id',
        'variant_id',
        'variant',
        'count',
        'name',
        'price',
        'discount',
        'coupon',
        'details',
    ];

    /**
     * The part below is for this model relationships
     */
    public function item(): MorphTo
    {
        return $this->morphTo();
    }

    public function order(): BelongsTo
    {
        return $this->belongsTo(Order::class);
    }

    public function inventory(): BelongsTo
    {
        return $this->belongsTo(ProductInventory::class, 'inventory_id');
    }

    public function variant(): BelongsTo
    {
        return $this->belongsTo(ProductInventoryVariant::class, 'variant_id');
    }
    /**
     * The above is for this model relationships
     */
}
