<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class ProductInventoryVariant extends Model
{
    protected $fillable = [
        'user_id',
        'product_inventory_id',
        'category_attribute_id',
        'category_attribute_item_id',
        'item_key',
        'item_value',
        'additional_price',
        'inventory_count',
        'data',
    ];

    /**
     * The part below is for this model relationships
     */
    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    public function inventory(): BelongsTo
    {
        return $this->belongsTo(ProductInventory::class);
    }

    public function attribute(): BelongsTo
    {
        return $this->belongsTo(CategoryAttribute::class, 'category_attribute_id');
    }

    public function attributeItem(): BelongsTo
    {
        return $this->belongsTo(CategoryAttributeItem::class, 'category_attributes_item_id');
    }
    /**
     * The above is for this model relationships
     */
}
