<?php

namespace App\Models;

use App\Traits\HasUniqueSlug;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Shop extends Model
{
    use HasUniqueSlug;
    protected string $slugSource = 'name';
    protected $fillable = [
        'user_id',
        'name',
        'slug',
        'logo',
        'description',
        'phone',
        'email',
        'address',
        'city',
        'state',
        'postal_code',
        'country',
        'is_approved',
        'approved_at',
    ];



    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }
}
