<?php

namespace App\Models;

use Illuminate\Support\Str;
use Illuminate\Database\Eloquent\Model;

class Tag extends Model
{
    protected $fillable = [
        'name',
        'slug',
        'description',
        'color',
    ];


    protected static function booted()
    {
        static::creating(function (Tag $tag) {
            $slug = Str::slug($tag->name);
            $slugCount = static::where('slug', 'like', "$slug%")->count();
            if (empty($tag->slug)) {
                $tag->slug = $slugCount > 0 ? "{$slug}-{$slugCount}" : $slug;
            }
        });

        static::updating(function (Tag $tag) {
            // Re-generate slug if the name changes and slug is not manually set
            if ($tag->isDirty('name') && empty($tag->slug)) {
                $tag->slug = Str::slug($tag->name);
            }
        });
    }
}
