<?php

namespace App\Services\Models;

use App\Models\Category;
use App\Models\CategoryAttribute;
use Illuminate\Support\Collection;
use Illuminate\Contracts\Database\Eloquent\Builder;

class CategoryAttributeService
{
    /**
     * this method will return all the attribute of the given category and its parents
     */
    public static function getCategoryAttributes(int|Category $category, bool $query = false): array|Builder|Collection
    {
        $category = $category instanceof Category ? $category : Category::where('id', $category)->first();

        if (!$category) {
            return [];
        }

        $categories = static::getCategoriesParents($category);
        $attributes = CategoryAttribute::with('items')->whereIn('category_id', $categories->pluck('id'));

        return $query ? $attributes : $attributes->get();
    }

    public static function getCategoriesParents(Category $category): Collection
    {
        $parents = collect();
        $parents->push($category);
        $currentCategory = $category;

        while ($currentCategory->parent_id) {
            $parent = Category::find($currentCategory->parent_id);
            if ($parent) {
                $parents->push($parent);
                $currentCategory = $parent;
            } else {
                break;
            }
        }

        return $parents;
    }

    public static function getCategoryPriceEffectiveAttributes($category)
    {
        return self::getCategoryAttributes($category , true)->where('is_price_effective', 1)->get();
    }
}
