<?php

namespace App\Traits;

use App\Models\File;
use Illuminate\Http\UploadedFile;
use App\Services\Models\FileService;
use Illuminate\Support\Facades\Storage;

trait HasFile
{
    public function files()
    {
        return $this->morphToMany(File::class, 'fileable', 'has_file');
    }

    public function file(): FileService
    {
        return app(FileService::class)->setModel($this);
    }
}
