<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('product_inventory_variants', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->cascadeOnDelete();
            $table->foreignId('product_inventory_id')->constrained('product_inventories')->cascadeOnDelete();
            $table->foreignId('category_attribute_id')->constrained();
            $table->foreignId('category_attribute_item_id')->nullable()->constrained();
            $table->string('item_key')->nullable();
            $table->string('item_value')->nullable();
            $table->string('additional_price')->nullable()->default('0');
            $table->integer('inventory_count')->nullable()->default(0);
            $table->json('data')->nullable();
            $table->auditable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('product_inventory_variants');
    }
};
