<?php

use App\Enums\PaymentStatusEnum;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('payments', function (Blueprint $table) {
            $table->id();
            $table->uuid('uuid')->unique();
            $table->foreignId('user_id')->constrained();
            $table->morphs('payable');
            $table->string('gateway')->nullable();
            $table->string('transaction_id')->nullable();
            $table->decimal('amount', 15, 4);
            $table->string('tracking_code')->unique();
            $table->text('description')->nullable();
            $table->enum('status', PaymentStatusEnum::values())->nullable()->default(PaymentStatusEnum::Pending->value);
            $table->json('data')->nullable();
            $table->auditable();
        });

        Schema::create('payment_steps', function (Blueprint $table) {
            $table->id();
            $table->foreignId('payment_id')->constrained();
            $table->enum('step', ['create', 'redirect', 'return', 'verify'])->nullable()->default('create');
            $table->unsignedSmallInteger('http_code')->nullable();
            $table->json('request')->nullable();
            $table->json('response')->nullable();
            $table->timestamp('request_time')->nullable();
            $table->string('return_id', '50')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('payments');
    }
};
