<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Permission;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Spatie\Permission\Models\Role;

class PermissionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $permissions = [
            'dashboard.view',

            'category.view',
            'category.attribute.edit',
            'category.attribute.delete',
            'category.attribute.item.view',
            'category.attribute.item.delete',

            'tag.view',
            'tag.edit',
            'tag.delete',

            'brand.view',
            'brand.edit',
            'brand.delete',

            'product.view',
            'product.view.own',
            'product.show',
            'product.edit',
            'product.delete',
            'product.add.inventory',

            'order.view',
            'order.view.own',

            'coupon.view',
            'coupon.edit',
            'coupon.delete',

            'comment.view',
            'comment.status.update',

            'post.view',
            'post.edit',
            'post.delete',

            'page.view',

            'office-equipment-group.view',
            'office-equipment-group.edit',
            'office-equipment-group.delete',

            'faq.category.view',
            'faq.category.edit',
            'faq.category.delete',

            'faq.tag.view',
            'faq.tag.edit',
            'faq.tag.delete',

            'faq.question.view',
            'faq.question.edit',
            'faq.question.delete',

            'faq.report.view',
            'faq.flag.delete',

            'file.manager.view',

            'option.panel.view',
            'option.view',

            'user.view',

            'shop.view',
            'shop.inventory.edit',
            'shop.inventory.delete',
            'shop.inventory.variant.create',
            'shop.inventory.variant.delete',
            'shop.profile.approve',
            'shop.profile.unapprove',

            'role.view',
            'permission.view',

            'settings.permission.edit',
            'settings.permission.delete',
            'settings.role.edit',
            'settings.role.delete',

            'settings.cache.refresh',
            'settings.cache.clear',
            'settings.cache.value',

            'footer.section.view',
            'site.status.view',
            'site.log.view',

            'component.alert.view',
            'component.tab.view',

            'delivery.view',
            'delivery.edit',
            'delivery.delete',

            'delivery.event.delete',
            'delivery.item.view',

            'delivery.day-capacity.view',
            'delivery.day-capacity.edit',
            'delivery.day-capacity.delete',

            'delivery.provider.edit',
            'delivery.provider.delete',

            'delivery.time.edit',
            'delivery.time.delete',
            'delivery.time.exception.view',

            'delivery.exceptions.edit',
            'delivery.exceptions.delete',

            'delivery.time-reservation.delete',
            'order.delivery-address.view',
        ];

        Permission::query()->delete();
        foreach ($permissions as $permission) {
            Permission::create(['name' => $permission]);
        }
    }
}
