<?php

namespace Database\Seeders;

use App\Models\Shop;
use App\Models\User;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;


class UsersShopsSeeder extends Seeder
{
    public function run()
    {
        // آرایه‌ای از داده‌های کاربران و فروشگاه‌ها
        $data = [
            [
                'user' => [
                    'name'     => 'علی رضایی',
                    'username' => 'alirezaei',
                    'email'    => 'ali@example.com',
                    'phone'    => '09121112222',
                    'password' => Hash::make('123456'),
                    'shop' => [
                        'name'        => 'فروشگاه علی',
                        'slug'        => 'shop-ali',
                        'logo'        => 'logos/ali.png',
                        'description' => 'فروش انواع محصولات متنوع به صورت آنلاین',
                        'phone'       => '021-12345678',
                        'email'       => 'shop.ali@example.com',
                        'address'     => 'خیابان ولیعصر، تهران',
                        'city'        => 'تهران',
                        'state'       => 'تهران',
                        'postal_code' => '1111111111',
                        'country'     => 'ایران',
                        'is_approved' => true,
                        'approved_at' => now(),
                    ],
                ],
            ],
            [
                'user' => [
                    'name'     => 'سمیرا محمدی',
                    'username' => 'samira.m',
                    'email'    => 'samira@example.com',
                    'phone'    => '09123334444',
                    'password' => Hash::make('123456'),
                    'shop' => [
                        'name'        => 'خانه‌ی سلینا',
                        'slug'        => 'selina-home',
                        'logo'        => 'logos/samira.png',
                        'description' => 'لوازم دکوری و هدیه‌های دست‌ساز',
                        'phone'       => '021-87654321',
                        'email'       => 'selina@example.com',
                        'address'     => 'میدان فردوسی، تهران',
                        'city'        => 'تهران',
                        'state'       => 'تهران',
                        'postal_code' => '2222222222',
                        'country'     => 'ایران',
                        'is_approved' => true,
                        'approved_at' => now(),
                    ],
                ],
            ],
            [
                'user' => [
                    'name'     => 'مهدی حسینی',
                    'username' => 'mehdi_h',
                    'email'    => 'mehdi@example.com',
                    'phone'    => '09125556666',
                    'password' => Hash::make('123456'),
                    'shop' => [
                        'name'        => 'دیجی‌مهدی',
                        'slug'        => 'digimehdi',
                        'logo'        => 'logos/mehdi.png',
                        'description' => 'تجهیزات دیجیتال و لوازم جانبی',
                        'phone'       => '021-11223344',
                        'email'       => 'digimehdi@example.com',
                        'address'     => 'خیابان آزادی، تهران',
                        'city'        => 'تهران',
                        'state'       => 'تهران',
                        'postal_code' => '3333333333',
                        'country'     => 'ایران',
                        'is_approved' => true,
                        'approved_at' => now(),
                    ],
                ],
            ],
        ];

        foreach ($data as $item) {
            // ایجاد کاربر
            $userData = $item['user'];
            $shopData = $userData['shop'];
            unset($userData['shop']);

            $user = User::create($userData);

            // ایجاد فروشگاه مرتبط
            $shopData['user_id'] = $user->id;
            Shop::create($shopData);
        }
    }
}
