<section class="container py-10">
    <div class="rounded-lg border bg-muted px-5 shadow lg:px-3">
        <!-- Title -->
        <div class="mb-8 mt-6 flex items-center justify-center gap-2 font-medium lg:text-lg xl:text-xl">
            <div class="i-hugeicons-coupon-percent size-7 stroke-2 text-warning"></div>
            <div>{{ $title }}</div>
        </div>

        <div class="grid grid-cols-2 gap-px bg-secondary lg:grid-cols-6 [&>*]:bg-muted">
            @foreach($products as $product)
            <a href="{{ $product['url'] }}" class="flex grow flex-col gap-6 px-4 py-3 lg:px-2">
                <img src="{{ $product['image'] }}" alt="{{ $product['title'] }}" class="rounded-lg aspect-square object-cover" />
                <div class="gap-x-1 text-end font-bold text-primary">
                    <div class="flex h-5 items-center justify-between text-sm text-text/50 xs:text-base">
                        @if(!empty($product['off_percent']))
                        <div class="rounded-full bg-warning px-2 py-px text-sm font-normal text-white">
                            {{ $product['off_percent'] }}%
                        </div>
                        @endif
                        @if(!empty($product['old_price']))
                        <del>{{ number_format($product['old_price']) }}</del>
                        @endif
                    </div>

                    <span class="text-sm xs:text-base">{{ number_format($product['price']) }}</span>
                    <span class="text-sm font-light">تومان</span>
                </div>
            </a>
            @endforeach
        </div>
    </div>
</section>
