@props(['wire' => false ,'order'])
<a href="{{ $wire ? 'javascript:;' : '' }}" wire:click="showOrderDetails({{ $order->id }})" class="block rounded-lg border p-4 shadow mb-3">
    <div class="flex items-center justify-between pb-6">
        <div class="flex items-center gap-x-2 text-white">
            <!-- <div class="i-lucide-circle-check size-6"></div> -->
            <p class="font-medium md:text-lg">
                {{ __($order->status) }}
            </p>
        </div>
        <div class="i-lucide-chevron-left size-6"></div>
    </div>
    <div class="mb-6 flex flex-col gap-6 xl:flex-row xl:justify-between xl:gap-16">
        <div class="flex flex-col gap-4 md:flex-row">
            <div class="flex items-center justify-between gap-x-2 md:justify-start">
                <div class="text-sm text-text/60 md:text-base">
                    {{ __('order number') }}
                </div>
                <div class="text-sm text-text/95 md:text-base">
                    {{ $order->tracking_code }}
                </div>
            </div>
            <div class="flex items-center justify-between gap-x-2 md:justify-start">
                <div class="text-sm text-text/60 md:text-base">
                    {{ number_format($order->amount) }}
                </div>
                <div class="flex items-center gap-1 text-primary">
                    <div class="font-bold md:text-lg">
                        {{ number_format($order->amount_with_discount) }}
                    </div>
                    <div class="text-sm md:text-base">
                        {{ getCurrency() }}
                    </div>
                </div>
            </div>
            <div class="flex items-center justify-between gap-x-2 md:justify-start">
                <div class="text-sm text-text/60 md:text-base">
                    {{ __('order date') }}
                </div>
                <div class="flex items-center gap-1 text-text/95">
                    {{ verta($order->created_at)->format('Y/m/d') }}
                </div>
            </div>
        </div>
        <div class="hidden flex-grow flex-col gap-y-4">
            <div class="flex items-center gap-x-2 text-yellow-500 dark:text-yellow-400">
                <div class="i-ic-baseline-pending-actions size-5"></div>

                <p class="text-sm font-medium md:text-base">در انتظار تایید</p>
            </div>
            <div class="relative h-2 w-full rounded-full bg-secondary">
                <span class="absolute inset-y-0 right-0 rounded-full bg-yellow-500 dark:bg-yellow-400" style="width: 25%"></span>
            </div>
            <div class="flex items-center justify-between text-sm text-yellow-500 dark:text-yellow-400 md:text-base"><span> 30 / ارديبهشت / ۱۴۰۳</span><span> ساعت 44 : 20 </span></div>
        </div>
    </div>

    <!-- Items Image -->
    <div class="swiper small-product-image-swiper">
        <div class="swiper-wrapper">
            @foreach ($order->items as $orderItem)
            <div class="swiper-slide">
                <img src="{{ $orderItem->item->brand_img }}" alt="{{ $orderItem->item->title ?? '' }}" class="size-20 rounded-xl" />
            </div>
            @endforeach

        </div>
    </div>
</a>
