@props([
'id' => 'drawer',
'title' => 'عنوان دراور',
])
<!-- Description Drawer -->
<div id="{{ $id }}" class="fixed inset-x-0 bottom-0 z-40 mx-auto h-[90dvh] w-full translate-y-full overflow-y-auto rounded-t-xl border-t bg-muted transition-transform duration-500 lg:max-w-3xl" tabindex="-1" aria-labelledby="{{ $id }}">
    <div class="flex h-full flex-col gap-4">
        <div class="flex items-center justify-between p-4">
            <div class="text-lg font-medium">
                {{ $title }}
            </div>
            <button class="text-text/60 duration-300 hover:text-text/95" data-drawer-hide="{{ $id }}" type="button">
                <div class="i-lucide-x size-6"></div>

                <span class="sr-only">{{ __('Close menu') }}</span>
            </button>
        </div>

        <div class="">
            {{ $slot }}
        </div>
    </div>
</div>
