@props([
    'name', // The name for the radio button group (e.g., 'rating')
    'maxRating' => 5, // The maximum number of stars
    'value' => null, // The currently selected rating value (e.g., 3 for 3 stars)
    'idPrefix' => 'star', // A prefix for the input IDs to ensure uniqueness
    'use_wire' => false, // Whether to use Livewire for two-way data binding
])

<!-- From Uiverse.io by SelfMadeSystem -->
<div {{ $attributes->merge(['class' => 'rating']) }} dir="ltr">
    @for ($i = 1; $i <= $maxRating; $i++)
        <input
            type="radio"
            id="{{ $idPrefix }}-{{ $name }}-{{ $i }}"
            name="{{ $name }}"
            value="{{ ($maxRating + 1) - $i }}"
            @if ((int)$value === $i) checked @endif
            @if ($use_wire) wire:model="{{ $name }}" @endif
        />
        <label for="{{ $idPrefix }}-{{ $name }}-{{ $i }}">
            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
                <path pathLength="360" d="M12,17.27L18.18,21L16.54,13.97L22,9.24L14.81,8.62L12,2L9.19,8.62L2,9.24L7.45,13.97L5.82,21L12,17.27Z"></path>
            </svg>
        </label>
    @endfor
</div>
