@props([
    'id' => 'select-' . uniqid(),
    'label' => 'انتخاب',
    'options' => [], // Expects an associative array: ['value' => 'Text', ...] or a simple array: ['Text1', 'Text2']
    'selected' => null,
    'placeholder' => 'گزینه ای را انتخاب کنید',
    'name' => '' // Added name attribute for form submission
])

<div>
    <label for="{{ $id }}" class="mb-2 block text-sm font-medium">
        {{ $label }}
    </label>
    <select id="{{ $id }}" name="{{ $name }}" {{ $attributes->merge(['class' => 'block w-full rounded-lg border bg-muted p-2.5 text-sm outline-none focus:border-emerald-500 focus:ring-emerald-500 dark:placeholder-zinc-400 dark:focus:border-emerald-500 dark:focus:ring-emerald-500']) }}>
        @if($placeholder)
            <option value="" @if(is_null($selected) || $selected === '') selected @endif disabled>{{ $placeholder }}</option>
        @endif
        @foreach ($options as $value => $text)
                <option value="{{ $value }}" @if($selected == $value) selected @endif>{{ $text }}</option>
        @endforeach
    </select>
</div>
