@props(['id' , 'title' => null , 'header' => null, 'footer' => null , 'width' => 'max-w-sm'])
<div id="{{ $id }}" tabindex="-1" aria-hidden="true" class="fixed left-0 right-0 top-0 z-50 hidden h-[calc(100%-1rem)] max-h-full w-full overflow-y-auto overflow-x-hidden p-4 md:inset-0">
    <div class="relative max-h-full w-full {{ $width }}">
        <div class="overflow-hidden rounded-lg border bg-muted shadow">
            <!-- Header -->
            <div class="px-4 py-5 sm:px-6">
                {{ $header }}
            </div>

            <div class="space-y-6 px-4 py-5 sm:p-6">
                <!-- Content -->
                <div class="">
                    {{ $slot }}
                </div>

                <!-- Footer -->
                <div class="">
                    {{ $footer }}
                </div>
            </div>
        </div>
    </div>
</div>
