<div>
    <!-- Simplicity is an acquired taste. - Katharine Gerould -->
</div>
<div>
    @if ($files && $files->count() > 0)
    <div class="card"> {{-- Added based on role/index.blade.php structure --}}
        <div class="card-body"> {{-- Added based on role/index.blade.php structure --}}
            <x-syndron.ui.table :columns="['Preview', 'Name', 'Extension', 'MIME Type', 'Size (Bytes)', 'Disk']"> {{-- Modified columns --}}
                @foreach ($files as $file)
                <tr>
                    <td>
                        @if (Str::startsWith($file->mime, 'image/'))
                        <img src="{{ asset('uploads/' . $file->path) }}" alt="{{ $file->name }}" style="max-width: 100px; max-height: 100px;">
                        @elseif (Str::startsWith($file->mime, 'video/'))
                        <video width="200" controls>
                            <source src="{{ asset('uploads/' . $file->path) }}" type="{{ $file->mime }}">
                            Your browser does not support the video tag.
                        </video>
                        @elseif (Str::startsWith($file->mime, 'audio/'))
                        <audio controls>
                            <source src="{{ asset('uploads/' . $file->path) }}" type="{{ $file->mime }}">
                            Your browser does not support the audio element.
                        </audio>
                        @else
                        <a href="{{ asset('uploads/' . $file->path) }}" target="_blank">View File</a>
                        @endif
                    </td>
                    <td>{{ $file->name }}</td>
                    <td>{{ $file->extension }}</td>
                    <td>{{ $file->mime }}</td>
                    <td>{{ $file->size }}</td>
                    <td>{{ $file->disk }}</td>
                </tr>
                @endforeach
            </x-syndron.ui.table>
        </div>
    </div>
    @else
    <p>No files available.</p>
    @endif
</div>
