@props([ 'post' => null ])
@php
$isEdit = isset($post) && $post->exists;
@endphp
<form action="{{ $isEdit ? route('admin.post.update', $post) : route('admin.post.store') }}" method="POST" enctype="multipart/form-data">
    @csrf
    @if($isEdit)
    @method('PUT')
    @endif

    <div class="mb-3">
        <label for="title" class="form-label">{{ __('Title') }}</label>
        <input type="text" name="title" id="title" class="form-control" value="{{ old('title', $post->title ?? '') }}" required>
        @error('title')
        <div class="text-danger">{{ $message }}</div>
        @enderror
    </div>

    <div class="mb-3">
        <label for="short_desc" class="form-label">{{ __('Short Description') }}</label>
        <textarea name="short_desc" id="short_desc" class="form-control">{{ old('short_desc', $post->short_desc ?? '') }}</textarea>
        @error('short_desc')
        <div class="text-danger">{{ $message }}</div>
        @enderror
    </div>

    <div class="mb-3">
        <label for="content" class="form-label">{{ __('Content') }}</label>
        <textarea name="content" id="content" rows="6" class="form-control">{{ old('content', $post->content ?? '') }}</textarea>
        @error('content')
        <div class="text-danger">{{ $message }}</div>
        @enderror
    </div>

    <div class="mb-3">
        <label for="price" class="form-label">{{ __('Price') }}</label>
        <input type="number" name="price" id="price" class="form-control" value="{{ old('price', $post->price ?? '') }}">
        @error('price')
        <div class="text-danger">{{ $message }}</div>
        @enderror
    </div>

    <div class="mb-3">
        <label for="status" class="form-label">{{ __('Status') }}</label>
        <select name="status" id="status" class="form-select">
            <option value="draft" @selected(old('status', $post->status ?? '') === 'draft')>{{ __('Draft') }}</option>
            <option value="published" @selected(old('status', $post->status ?? '') === 'published')>{{ __('Published') }}</option>
        </select>
        @error('status')
        <div class="text-danger">{{ $message }}</div>
        @enderror
    </div>

    <div class="mb-3">
        <label for="img" class="form-label">{{ __('Image') }}</label>
        <input type="file" name="img" id="img" class="form-control">
        @error('img')
        <div class="text-danger">{{ $message }}</div>
        @enderror
        @if($isEdit && $post->img)
        <div class="mt-2">
            <img src="{{ asset($post->img) }}" alt="Image Preview" class="img-thumbnail" width="150">
        </div>
        @endif
    </div>

    <div class="mb-3">
        <label for="video" class="form-label">{{ __('Video') }}</label>
        <input type="file" name="video" id="video" class="form-control">
        @error('video')
        <div class="text-danger">{{ $message }}</div>
        @enderror
        @if($isEdit && $post->video)
        <div class="mt-2">
            <video width="200" controls>
                <source src="{{ asset($post->video) }}" type="video/mp4">
                Your browser does not support the video tag.
            </video>
        </div>
        @endif
    </div>

    <div class="border border-3 p-4 rounded mb-3 d-flex flex-column gap-3">
        <label for="files" class="form-label d-block"> {{ __('files') }} </label>
        <x-syndron.ui.file-upload-v2 name="files[]" />
    </div>

    <button type="submit" class="btn btn-primary">
        {{ $isEdit ? __('Edit') : __('Submit') }}
    </button>
</form>
