@props(['brand' => null])

@php
$isEdit = isset($brand) && $brand->exists;
@endphp

<form class="" action="{{ $isEdit ? route('admin.brands.update', $brand) : route('admin.brands.store') }}" method="POST" enctype="multipart/form-data">
    @csrf
    @if($isEdit)
    @method('PUT')
    @endif

    <div class="mb-3">
        <label class="form-label">{{ __('Name') }}</label>
        <input type="text" name="name" value="{{ old('name', $brand->name ?? '') }}" class="form-control @error('name') is-invalid @enderror">
        @error('name')
        <div class="invalid-feedback">{{ $message }}</div>
        @enderror
    </div>

    <div class="mb-3">
        <label class="form-label">{{ __('Slug') }}</label>
        <input type="text" name="slug" value="{{ old('slug', $brand->slug ?? '') }}" class="form-control @error('slug') is-invalid @enderror">
        @error('slug')
        <div class="invalid-feedback">{{ $message }}</div>
        @enderror
    </div>


    <div class="mb-3">
        <label for="category_id">{{ __('Category') }}</label>
        <select name="category_id" class="form-select @error('category_id') is-invalid @enderror">
            <option value="">{{ __('Select Category') }}</option>
            @foreach(\App\Models\Category::all() as $category)
            <option value="{{ $category->id }}" {{ (old('category_id', $brand->category_id ?? '') == $category->id) ? 'selected' : '' }}>
                {{ $category->name }}
            </option>
            @endforeach
        </select>
        @error('category_id')
        <div class="invalid-feedback">{{ $message }}</div>
        @enderror
    </div>

    <div class="mb-3">
        <label class="form-label">{{ __('Description') }}</label>
        <textarea name="description" class="form-control @error('description') is-invalid @enderror">{{ old('description', $brand->description ?? '') }}</textarea>
        @error('description')
        <div class="invalid-feedback">{{ $message }}</div>
        @enderror
    </div>

    <div class="mb-3">
        <label class="form-label">{{ __('Logo') }}</label>
        <input type="file" name="logo" class="form-control @error('logo') is-invalid @enderror">
        @error('logo')
        <div class="invalid-feedback">{{ $message }}</div>
        @enderror
        @if($isEdit && $brand->logo)
        <img src="{{ asset('uploads/' . $brand->logo) }}" class="img-thumbnail mt-2" style="max-height: 150px;">
        @endif
    </div>

    <button type="submit" class="btn btn-primary">{{ $isEdit ? 'Update' : 'Create' }} {{ __('Brand') }}</button>
</form>
