@props(['time' => null])

@php
$isEdit = $time !== null;
@endphp
<div>
    <form action="{{ $isEdit ? route('admin.delivery.times.update' , $time->id) : route('admin.delivery.times.store') }}" method="post">
        @csrf
        @if ($isEdit)
        @method('PATCH')
        @endif

        <div class="row">
            <!-- day -->
            <div class="mb-3 col-12">
                <label for="day" class="form-label">{{ __('day') }}</label>
                <select name="day" id="day" class="form-select">
                    <option value=""> {{ __('chose') }}</option>
                    <option value="0" {{ old('day' , $time->day ?? '') == '0' ? 'selected' : '' }}>0</option>
                    <option value="1" {{ old('day' , $time->day ?? '') == '1' ? 'selected' : '' }}>1</option>
                    <option value="2" {{ old('day' , $time->day ?? '') == '2' ? 'selected' : '' }}>2</option>
                    <option value="3" {{ old('day' , $time->day ?? '') == '3' ? 'selected' : '' }}>3</option>
                    <option value="4" {{ old('day' , $time->day ?? '') == '4' ? 'selected' : '' }}>4</option>
                    <option value="5" {{ old('day' , $time->day ?? '') == '5' ? 'selected' : '' }}>5</option>
                    <option value="6" {{ old('day' , $time->day ?? '') == '6' ? 'selected' : '' }}>6</option>
                </select>
                @error('name')
                <small class="text-sm text-danger">
                    {{ $message }}
                </small>
                @enderror
            </div>
            <!-- from -->
            <div class="mb-3 col-12">
                <label for="from" class="form-label">{{ __('from') }}</label>
                <input type="time"  name="from" id="from" class="form-control" value="{{ old('from' , $time->from ?? '') }}">
                @error('from')
                <small class="text-sm text-danger">
                    {{ $message }}
                </small>
                @enderror
            </div>
            <!-- until -->
            <div class="mb-3 col-12">
                <label for="until" class="form-label">{{ __('Until') }}</label>
                <input type="time" name="until" id="until" class="form-control" value="{{ old('until' , $time->until ?? '') }}">
                @error('until')
                <small class="text-sm text-danger">
                    {{ $message }}
                </small>
                @enderror
            </div>
            <!-- capacity -->
            <div class="mb-3 col-12">
                <label for="capacity" class="form-label">{{ __('Capacity') }}</label>
                <input type="text" name="capacity" id="capacity" class="form-control" value="{{ old('capacity' , $time->capacity ?? '') }}">
                @error('capacity')
                <small class="text-sm text-danger">
                    {{ $message }}
                </small>
                @enderror
            </div>


            <div class="d-flex justify-content-end">
                <button type="submit" class="btn btn-primary ">
                    {{ __('Add a new time') }}
                </button>
            </div>
        </div>
    </form>
</div>
