@props(['group' => null])

@php
$isEdit = isset($group) && $group->exists;
@endphp

<form action="{{ $isEdit ? route('admin.office-equipment-groups.update', $group) : route('admin.office-equipment-groups.store') }}" method="POST">
    @csrf
    @if($isEdit)
        @method('PUT')
    @endif

    <div class="mb-3">
        <label class="form-label">{{ __('Name') }}</label>
        <input type="text" name="name" value="{{ old('name', $group->name ?? '') }}" class="form-control @error('name') is-invalid @enderror">
        @error('name')
        <div class="invalid-feedback">{{ $message }}</div>
        @enderror
    </div>

    <div class="mb-3">
        <label class="form-label">{{ __('Description') }}</label>
        <textarea name="description" class="form-control @error('description') is-invalid @enderror">{{ old('description', $group->description ?? '') }}</textarea>
        @error('description')
        <div class="invalid-feedback">{{ $message }}</div>
        @enderror
    </div>

    <div class="mb-3">
        <label class="form-label">{{ __('Created By') }}</label>
        <input type="text" name="created_by" value="{{ old('created_by', $group->created_by ?? '') }}" class="form-control @error('created_by') is-invalid @enderror">
        @error('created_by')
        <div class="invalid-feedback">{{ $message }}</div>
        @enderror
    </div>

    <button type="submit" class="btn btn-primary">{{ $isEdit ? 'Update' : 'Create' }} {{ __('Office Equipment Group') }}</button>
</form>