@props(['category' => null , 'product' => null])

@php
$isEdit = isset($product) && $product->exists;
@endphp

<div>
    @if ($errors->any())
    <x-syndron.ui.alert type="danger" title="{{ __('error') }}" icon="bx bxs-message-square-x">
        <ul>
            @foreach ($errors->all() as $error)
            <li>{{ $error }}</li>
            @endforeach
        </ul>
    </x-syndron.ui.alert>
    @endif

    <form class="" action="{{ $isEdit ? route('admin.product.update', ['category' => $category->id , 'product' => $product->id]) : route('admin.product.store' ,$category->id) }}" method="POST" enctype="multipart/form-data">
        @csrf
        @if($isEdit)
        @method('PUT')
        @endif

        <input type="hidden" name="category_id" value="{{ $category->id }}">

        <div class="row">
            <div class="col-sm-8">
                <x-syndron.form.product.static-inputs :product="$product" />

                <x-syndron.form.product.category-attributes :category="$category" :product="$product" />

                <x-syndron.ui.file-input name="image" label="Upload Image" old="{{ $product->brand_img ?? null}}" />


                <div class="border border-3 p-4 rounded mb-3 d-flex flex-column gap-3">
                    <label for="images" class="form-label d-block"> {{ __('product images') }} </label>
                    <x-syndron.ui.file-upload-v2 name="images[]" />
                </div>

                @if ($isEdit)
                <div class="border border-3 p-4 rounded mb-3 ">
                    @foreach ($product->getMetaByKey('gallery') as $image )
                    <x-syndron.ui.form.image-checkbox id="image_{{ $image->id }}" image="{{ $image->value }}" name="delete_images" value="{{ $image->id }}" />
                    @endforeach
                </div>
                @endif

            </div>
            <div class="col-sm-4">
                <x-syndron.form.product.static-second-inputs :product="$product" />

                <div class="border border-3 p-4 rounded mb-3 d-flex flex-column gap-3">
                    <button class="btn btn-primary" type="submit">
                        {{ $isEdit ? __('Update') : __('Create') }}
                    </button>
                </div>
            </div>
        </div>


    </form>
</div>
