@props([ 'role' => null, 'permissions' => []])

@php
$isEdit = isset($role) && $role->exists;
@endphp

<form action="{{ $isEdit ? route('admin.settings.role.update' , $role->id ) : route('admin.settings.role.store') }}" method="POST">
    @csrf

    @if($isEdit)
    @method('PATCH')
    @endif

    <div class="mb-3">
        <label for="name" class="form-label">{{ __('Role Name') }}</label>
        <input type="text" name="name" class="form-control" value="{{ old('name', $role->name ?? '') }}" required>
    </div>

    <div class="mb-3">
        <label class="form-label">{{ __('Permissions') }}</label>
        <div class="row">
            @foreach ($permissions as $permission)
            <div class="col-4">
                <div class="form-check">
                    <input id="permission-{{ $permission->id }}" class="form-check-input" type="checkbox"
                        name="permissions[]" value="{{ $permission->name }}"
                        {{ isset($role) && $role->hasPermissionTo($permission->name) ? 'checked' : '' }}>
                    <label class="form-check-label cursor-pointer" for="permission-{{ $permission->id }}">{{ $permission->name }}</label>
                </div>
            </div>
            @endforeach
        </div>
    </div>

    <button type="submit" class="btn btn-primary">{{ __('Save') }}</button>
</form>
