<div class="card">
    <img src="{{ $product->brand_img ?? '' }}" class="card-img-top square-box" alt="{{ $product->title }}">
    <div class="">
        @if (isset($product->off_rate) && $product->off_rate != 0)
        <div class="position-absolute top-0 end-0 m-3 product-discount">
            <span class="">
                {{ $product->off_rate }}%
            </span>
        </div>
        @endif
    </div>
    <div class="card-body">
        <h6 class="card-title cursor-pointer">

            <a class="text-black " href="{{ Route::is('admin.shop.product-selection') ? route('admin.shop.add.inventory',$product->id): route('admin.product.show',$product->id) }}">
                {{ $product->title ?? __('without title') }}
            </a>
        </h6>
        <p onclick="navigator.clipboard.writeText(this.getAttribute('data-code')); app.toast.fire({icon: 'success',title: 'copied successfully'});" data-code="{{ $product->code }}">
            {{ __('code') }}: {{ $product->code }}
        </p>
        <div class="clearfix">
            <p class="d-none mb-0 float-start"><strong>134</strong> Sales</p>
            @if ($product->discount_price != 0 && $product->discount_price != null)
            <p class="mb-0 float-end fw-bold">
                <span @if($product->discount_price) class="me-2 text-decoration-line-through text-secondary" @endif>
                    {{ is_numeric($product->price) ? number_format($product->price) : $product->price }}
                </span>
                <span>
                    {{ is_numeric($product->discount_price) ? number_format($product->discount_price) : $product->discount_price }}
                </span>
            </p>
            @else
            <span>
                {{ is_numeric($product->price) ? number_format($product->price) : $product->price }}
            </span>
            @endif
        </div>
        <!-- d-flex -->
        <div class="d-none align-items-center mt-3 fs-6">
            <div class="cursor-pointer">
                <i class="bx bxs-star text-warning"></i>
                <i class="bx bxs-star text-warning"></i>
                <i class="bx bxs-star text-warning"></i>
                <i class="bx bxs-star text-warning"></i>
                <i class="bx bxs-star text-secondary"></i>
            </div>
            <p class="mb-0 ms-auto">4.2(182)</p>
        </div>
    </div>
</div>

