<div data-onscrollclass="-translate-y-full" class="absolute inset-x-0 top-full z-20 bg-muted duration-300">
    <nav class="container flex items-center gap-2 text-text/80">
        <!-- indicator -->
        <div id="line" class="absolute bottom-0 end-0 top-full h-1 rounded-xl bg-primary transition-all duration-300"></div>
        <!-- Mega Menu -->
        <ul class="desktop-nav-item relative z-10" onmouseenter="desktopMegamenuShow()" onmouseleave="desktopMegamenuHidden()">
            <!-- category-->
            <div class="flex cursor-pointer items-center gap-2 pb-2 pl-2">
                <div class="i-lucide-align-justify h-4 w-4"></div>
                <div>{{ __('Categories') }}</div>
            </div>

            <div id="desktop-mega-menu" class="absolute right-0 top-full hidden h-[400px] w-[900px] overflow-hidden rounded-b-lg bg-muted">
                <!-- menu -->
                <div class="flex">
                    <!-- right Menu -->
                    <div dir="ltr" class="max-h-[400px] min-h-[400px] min-w-[200px] overflow-y-auto bg-background">
                        <ul id="desktopMegamenuCategory" dir="rtl" class="flex flex-col">
                            @foreach (cacheable(\App\Cache\CategoryTreeCache::class)->get() as $category)
                            <li>
                                <a href="{{ route('shop' , ['category' => $category->id]) }}" class="mega-menu-link">{{ $category->name }}</a>
                            </li>
                            @endforeach
                        </ul>
                    </div>

                    <!-- left Menu -->
                    <div dir="ltr" class="max-h-[400px] min-h-[400px] overflow-y-auto p-6">
                        <div dir="rtl" id="desktopMegamenuSubCategory">
                            @foreach (cacheable(\App\Cache\CategoryTreeCache::class)->get() as $category )
                            <!-- man menu -->
                            <div class="hidden">
                                <div class="mb-6">
                                    <a href="{{ route('shop' , ['category' => $category->id]) }}" class="flex items-center gap-x-1 text-sm text-primary duration-200 hover:text-primary/80">
                                        <span>{{ __('see all') }}</span>
                                        <i class="i-lucide-chevron-left"></i>
                                    </a>
                                </div>

                                <div class="flex flex-wrap gap-x-14 gap-y-8">
                                    @isset($category->children)
                                    @foreach ($category->children as $childCategory )
                                    <ul class="flex flex-col space-y-4">
                                        <li>
                                            <a href="{{ route('shop' , ['category' => $childCategory->id]) }}" class="block flex items-center gap-x-2 duration-200 hover:text-primary">
                                                <span class="h-5 w-0.5 rounded-full bg-primary"></span>
                                                <span> {{ $childCategory->name }} </span>
                                                <i class="i-lucide-chevron-left text-sm"></i>
                                            </a>
                                        </li>
                                        @isset($childCategory->children)
                                        @foreach ($childCategory->children as $grandChildCategory )
                                        <li>
                                            <a href="{{ route('shop' , ['category' => $grandChildCategory->id]) }}" class="block text-sm duration-200 hover:text-primary">{{ $grandChildCategory->name }}</a>
                                        </li>
                                        @endforeach
                                        @endisset


                                    </ul>
                                    @endforeach
                                    @endisset

                                </div>
                            </div>
                            @endforeach

                        </div>
                    </div>
                </div>
            </div>
        </ul>

        <ul class="desktop-nav-item">
            <a href="{{ route('home') }}" class="inline-block px-2 pb-2"> {{ __('Home') }} </a>
        </ul>
        <ul class="desktop-nav-item">
            <a href="{{ route('shop') }}" class="inline-block px-2 pb-2"> {{ __('Shop') }} </a>
        </ul>
        <ul class="desktop-nav-item">
            <a href="{{ route('blog') }}" class="inline-block px-2 pb-2"> {{ __('Blog') }} </a>
        </ul>
        <ul class="desktop-nav-item">
            <a href="{{ route('office-equipment') }}" class="inline-block px-2 pb-2"> {{ __('Office Equipment') }} </a>
        </ul>
        <ul class="desktop-nav-item">
            <a href="{{ route('faq.home') }}" class="inline-block px-2 pb-2"> {{ __('Faq') }} </a>
        </ul>


        <!-- Indicator -->
        <div id="desktopNavbarIndicator" class="absolute bottom-0 end-0 z-0 h-[0.15625rem] w-0 touch-none rounded-full bg-primary transition-all duration-300 ease-[ease]"></div>
    </nav>
</div>
