<div class="">
    <h5 class="d-flex justify-content-between">
        <span>
            <i class="bx bx-folder"></i>
            {{ __('Folders') }}
        </span>
        <button wire:click="goBack" class="btn btn-sm btn-outline-primary d-flex align-items-center justify-content-center gap-1">
            {{ __('Back') }}
            <i class="bx bx-chevron-left"></i>
        </button>
    </h5>

    <div class="row mt-3">
        @foreach($directories as $folder)
        <div class="col-12 col-lg-4">
            <div class="card shadow-none border radius-15" wire:click="goToDirectory('{{ $folder }}')" style="cursor: pointer;">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="font-30 text-primary"><i class="bx bxs-folder"></i></div>
                    </div>
                    <h6 class="mb-0 text-primary">{{ basename($folder) }}</h6>
                    <small>{{ count(Storage::disk($disk)->files($folder)) }}
                        {{ __('file') }}
                    </small>
                </div>
            </div>
        </div>
        @endforeach
    </div>

    <div class="table-responsive mt-3">
        <table class="table table-striped table-hover table-sm mb-0">
            <thead>
                <tr>
                    <th>{{ __('Name') }}</th>
                    <th>{{ __('Size') }}</th>
                    <th>{{ __('Last Modified') }}</th>
                    <th></th>
                </tr>
            </thead>
            <tbody>
                @foreach($files as $file)
                @php
                $url = Storage::disk($disk)->url($file);
                $extension = pathinfo($file, PATHINFO_EXTENSION);
                $isImage = in_array(strtolower($extension), ['jpg', 'jpeg', 'png', 'gif', 'webp']);
                @endphp
                <tr>
                    <td>
                        <div class="d-flex align-items-center">
                            @if($isImage)
                            <img src="{{ $url }}" width="40" class="me-2 rounded border square-box" alt="preview">
                            @else
                            <i class="bx bxs-file me-2 font-24 text-secondary"></i>
                            @endif
                            <div class="font-weight-bold">{{ basename($file) }}</div>
                        </div>
                    </td>
                    <td>{{ number_format(Storage::disk($disk)->size($file) / 1024, 2) }} KB</td>
                    <td>{{ date('M d, Y', Storage::disk($disk)->lastModified($file)) }}</td>
                    <td>
                        <button class="btn btn-sm btn-outline-primary" onclick="navigator.clipboard.writeText('{{ $url }}')">
                            {{ __('Copy URL') }}
                        </button>
                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>
