<div class="z-10 w-full py-10 xs:container">
    <div class="relative mx-auto bg-muted px-4 py-8 xs:max-w-[440px] xs:rounded-xl lg:px-10 lg:py-12">
        <form class="flex flex-col">
            <!-- logo -->
            <a href="{{ route('home') }}" class="mb-10">
                <img src="{{ asset('uploads/'.getSiteLogo()) }}" alt="logo" class="mx-auto h-10 xs:h-12" />
            </a>

            <h1 class="mb-8 text-center font-medium xs:text-lg">
                {{ __("Login or Register") }}
            </h1>

            <!-- username -->
            <div class="mb-4 w-full space-y-3">
                <label for="username" class="relative block w-full rounded-lg border bg-muted shadow-sm duration-300 focus-within:border-primary">
                    <input wire:model="identifier" wire:keydown.prevent.enter="handel" dir="ltr" type="text" id="username" placeholder=" " class="peer w-full rounded-lg bg-transparent p-3 text-left placeholder-transparent outline-none focus:ring-0 xs:p-4" />
                    <span class="pointer-events-none absolute start-3 -translate-y-1/2 rounded-full bg-muted px-2 text-xs text-text/80 transition-all duration-200 peer-placeholder-shown:top-1/2 peer-placeholder-shown:text-sm peer-focus:text-xs peer-focus:peer-placeholder-shown:top-0 xs:text-sm md:text-sm md:peer-placeholder-shown:text-base md:peer-focus:text-sm lg:start-5">
                        {{ __('Email or your phone number')  }}
                    </span>
                </label>
                <p class="h-5 text-sm text-warning">
                    @error('identifier') {{ $message }} @enderror
                </p>
            </div>

            <button type="button" wire:click="handel" wire:loading.attr="disabled" wire:target="handel" class="btn-primary py-3">
                {{ __('Login') }}

                <div wire:loading class="i-lucide-loader-circle animate-spin"></div>
            </button>
            <!-- rules -->
            <p class="mt-5 text-center text-sm text-text/80">
                {{ __('By entering the store, you accept all') }}
                <a href="{{ route('rules') }}" class="text-primary duration-200 hover:text-primary/80">{{ __('rules') }}.</a>
            </p>
        </form>
    </div>
</div>
