<div>
    <div class="z-10 w-full py-10 xs:container">
        <div class="relative mx-auto bg-muted px-4 py-8 xs:max-w-[440px] xs:rounded-xl lg:px-10 lg:py-12">
            <!-- Return previous Section -->
            <button type="button" wire:click="goBackToIdentifier" class="absolute right-2 top-2 flex size-10 items-center justify-center rounded-full border bg-background text-primary duration-300 hover:bg-primary-btn hover:text-background xs:-right-2 xs:-top-2">
                <i class="i-carbon-chevron-right size-7 stroke-2"></i>
            </button>
            <div class="flex flex-col">
                <!-- logo -->
                <a href="{{ route('home') }}" class="mb-10">
                    <img src="{{ asset('uploads/'.getSiteLogo()) }}" alt="{{ getSiteName() }}" class="mx-auto h-10 xs:h-12" />
                </a>

                <h1 class="mb-8 text-center font-medium xs:text-lg">{{ __('Enter the OTP code') }} </h1>


                <!-- otp -->
                <input type="number" id="otp-code" wire:model="otpCode" hidden>
                <div class="mb-4 w-full space-y-6">
                    <div id="otp-form" class="flex items-center justify-between gap-x-2" dir="ltr">
                        <input type="number" inputmode="numeric" class="otp-input h-14 w-14 rounded-lg border bg-muted text-center text-lg outline-none xs:h-16 xs:w-16 md:text-xl" maxlength="1" />
                        <input type="number" inputmode="numeric" class="otp-input h-14 w-14 rounded-lg border bg-muted text-center text-lg outline-none xs:h-16 xs:w-16 md:text-xl" maxlength="1" />
                        <input type="number" inputmode="numeric" class="otp-input h-14 w-14 rounded-lg border bg-muted text-center text-lg outline-none xs:h-16 xs:w-16 md:text-xl" maxlength="1" />
                        <input type="number" inputmode="numeric" class="otp-input h-14 w-14 rounded-lg border bg-muted text-center text-lg outline-none xs:h-16 xs:w-16 md:text-xl" maxlength="1" />
                        <input type="number" inputmode="numeric" class="otp-input h-14 w-14 rounded-lg border bg-muted text-center text-lg outline-none xs:h-16 xs:w-16 md:text-xl" maxlength="1" />
                    </div>
                    <p class="h-5 text-sm text-warning">
                        @error('error') {{ $message }} @enderror
                        @error('otpCode') {{ $message }} @enderror
                    </p>
                </div>
                <ul class="mb-6 space-y-4">
                    <li>
                        <p class="text-sm text-primary/60" id="countdownSection">
                            {{ __('Time remaining to resend') }}
                            <span id="countdown" class="font-bold">2:00</span>
                        </p>
                        <button type="button" id="resendButton" wire:click="sendOtp" class="hidden text-sm text-primary">
                            <span> {{ __('Resend verification code') }} </span>

                            <span>
                                <svg class="h-5 w-5">
                                    <use xlink:href="#chevron-left" />
                                </svg>
                            </span>
                        </button>
                    </li>
                    <li>
                        <button type="button" wire:click="loginWithPassword" class="flex items-center gap-1 text-sm text-primary duration-200 hover:text-primary/80">
                            {{ __('Login in with password') }}
                            <i class="i-carbon-chevron-left size-4"></i>
                        </button>
                    </li>
                </ul>

                <button type="button" class="btn-primary py-3" wire:click="verifyOTP" wire:loading.attr="disabled" wire:target="verifyOTP">
                     {{ __('submit') }}

                     <div wire:loading class="i-lucide-loader-circle animate-spin"></div>
                    </button>
            </div>
        </div>
    </div>


    @script
    <script>
        startCountdown(); // Start the countdown when the page loads

        form = document.querySelector("#otp-form");
        inputs = document.querySelectorAll(".otp-input");

        inputs[0].focus();

        form.addEventListener("input", (e) => {
            const target = e.target;
            const value = target.value;

            if (!/^\d$/.test(value)) {
                target.value = ""; // Allow only single digits
                return;
            }

            toggleFilledClass(target);

            if (target.nextElementSibling && value) {
                target.nextElementSibling.focus();
            }

            if (isAllInputFilled()) {
                document.getElementById('otp-code').value = getOtpText();
                // Trigger the input event
                const event = new Event('input', {
                    bubbles: true
                });
                document.getElementById('otp-code').dispatchEvent(event);
            }
        });

        inputs.forEach((input, currentIndex) => {
            toggleFilledClass(input);

            input.addEventListener("paste", (e) => {
                e.preventDefault();
                const text = e.clipboardData
                    .getData("text")
                    .replace(/\D/g, "")
                    .slice(0, inputs.length - currentIndex);

                inputs.forEach((item, index) => {
                    if (index >= currentIndex && text[index - currentIndex]) {
                        item.focus();
                        item.value = text[index - currentIndex];
                        toggleFilledClass(item);
                    }
                });

                if (isAllInputFilled()) {
                    document.getElementById('otp-code').value = getOtpText(); // Call alert every time all inputs are filled
                    // Trigger the input event
                    const event = new Event('input', {
                        bubbles: true
                    });
                    document.getElementById('otp-code').dispatchEvent(event);
                }
            });

            input.addEventListener("keydown", (e) => {
                if (e.key === "Backspace" || e.key === "Delete") {
                    e.preventDefault();
                    input.value = "";
                    toggleFilledClass(input);
                    if (input.previousElementSibling) {
                        input.previousElementSibling.focus();
                    }
                }
            });

            input.addEventListener("input", () => {
                if (input.value.length > 1) {
                    input.value = input.value.slice(-1); // Keep only the last digit
                }
            });
        });
    </script>
    @endscript
</div>
