<div>
    @if ($orderDetails == null)
    @foreach ($orders as $order)
    <x-blesser.element.single-order-card :wire="true" :order="$order" />
    @endforeach
    @endif

    @if ($orderDetails != null)
    <div class="mb-3 flex justify-end">
        <button class="btn-primary rounded-lg px-4 py-2" wire:click="clearOrderDetails">
            {{ __('Back to orders') }}
        </button>
    </div>
    <h5 class="text-2xl mb-4">{{ __('Order Details') }}</h5>
    <div class="block rounded-lg border p-4 shadow mb-3">
        <div class="grid grid-cols-1 md:grid-cols-12 gap-4 mb-3">
            <div class="md:col-span-4 font-semibold">{{ __('Tracking Code') }}:</div>
            <div class="md:col-span-8">{{ $orderDetails->tracking_code }}</div>
        </div>
        <div class="grid grid-cols-1 md:grid-cols-12 gap-4 mb-3">
            <div class="md:col-span-4 font-semibold">{{ __('Order UUID') }}:</div>
            <div class="md:col-span-8">{{ $orderDetails->uuid }}</div>
        </div>
        <div class="grid grid-cols-1 md:grid-cols-12 gap-4 mb-3">
            <div class="md:col-span-4 font-semibold">{{ __('Customer Name') }}:</div>
            <div class="md:col-span-8">{{ $orderDetails->name }}</div>
        </div>
        <div class="grid grid-cols-1 md:grid-cols-12 gap-4 mb-3">
            <div class="md:col-span-4 font-semibold">{{ __('Customer Email') }}:</div>
            <div class="md:col-span-8">{{ $orderDetails->email }}</div>
        </div>
        <div class="grid grid-cols-1 md:grid-cols-12 gap-4 mb-3">
            <div class="md:col-span-4 font-semibold">{{ __('Customer Phone') }}:</div>
            <div class="md:col-span-8">{{ $orderDetails->phone }}</div>
        </div>
        <div class="grid grid-cols-1 md:grid-cols-12 gap-4 mb-3">
            <div class="md:col-span-4 font-semibold">{{ __('Order Type') }}:</div>
            <div class="md:col-span-8">{{ __(ucfirst($orderDetails->type)) }}</div>
        </div>
        <hr class="my-4">
        <div class="grid grid-cols-1 md:grid-cols-12 gap-4 mb-3">
            <div class="md:col-span-4 font-semibold">{{ __('Total Amount') }}:</div>
            <div class="md:col-span-8">{{ number_format($orderDetails->amount) }}</div>
        </div>
        <div class="grid grid-cols-1 md:grid-cols-12 gap-4 mb-3">
            <div class="md:col-span-4 font-semibold">{{ __('Discount') }}:</div>
            <div class="md:col-span-8">{{ $orderDetails->discount }}</div>
        </div>
        <div class="grid grid-cols-1 md:grid-cols-12 gap-4 mb-3">
            <div class="md:col-span-4 font-semibold">{{ __('Final Amount') }}:</div>
            <div class="md:col-span-8">{{ $orderDetails->amount_with_discount }}</div>
        </div>
        @if($orderDetails->coupon)
        <div class="grid grid-cols-1 md:grid-cols-12 gap-4 mb-3">
            <div class="md:col-span-4 font-semibold">{{ __('Coupon Used') }}:</div>
            <div class="md:col-span-8">{{ $orderDetails->coupon->code }}</div>
        </div>
        @endif
        <hr class="my-4">
        <div class="grid grid-cols-1 md:grid-cols-12 gap-4 mb-3">
            <div class="md:col-span-4 font-semibold">{{ __('Status') }}:</div>
            <div class="md:col-span-8"><span class="bg-blue-100 text-blue-800 text-sm font-medium me-2 px-2.5 py-0.5 rounded">{{ __(ucfirst($orderDetails->status)) }}</span></div>
        </div>
        @if($orderDetails->reseller)
        <div class="grid grid-cols-1 md:grid-cols-12 gap-4 mb-3">
            <div class="md:col-span-4 font-semibold">{{ __('Reseller') }}:</div>
            <div class="md:col-span-8">{{ $orderDetails->reseller }}</div>
        </div>
        @endif
        @if($orderDetails->description)
        <div class="grid grid-cols-1 md:grid-cols-12 gap-4 mb-3">
            <div class="md:col-span-4 font-semibold">{{ __('Description/Notes') }}:</div>
            <div class="md:col-span-8">{{ $orderDetails->description }}</div>
        </div>
        @endif
        <hr class="my-4">
        <div class="grid grid-cols-1 md:grid-cols-12 gap-4 mb-3">
            <div class="md:col-span-4 font-semibold">{{ __('Order Date') }}:</div>
            <div class="md:col-span-8">{{ verta($orderDetails->created_at)->format('F j, Y, g:i a') }}</div>
        </div>
        <div class="grid grid-cols-1 md:grid-cols-12 gap-4 mb-3">
            <div class="md:col-span-4 font-semibold">{{ __('Last Updated') }}:</div>
            <div class="md:col-span-8">{{ verta($orderDetails->updated_at)->format('F j, Y, g:i a') }}</div>
        </div>
        @if($orderDetails->address)
        <hr class="my-4">
        <h5 class="text-lg font-bold mb-2">{{ __('Shipping Address') }}</h5>
        <p>{{ $orderDetails->address->full_address_line_with_phone ?? $orderDetails->address->address_line_1 }}</p>
        @endif
        @if($orderDetails->deliveryTime)
        <hr class="my-4">
        <h5 class="text-lg font-bold mb-2">{{ __('Preferred Delivery Time') }}</h5>
        <p>{{ $orderDetails->deliveryTime->name }}</p>
        @endif
    </div>

    <div class="mb-8">
        <h3 class="mb-8 flex items-center gap-x-4 text-lg text-text/80">
            <span class="h-2 w-2 rounded-full bg-primary"></span>
            {{ __('Order Items') }}
            <span class="text-sm text-text/60"> ( {{ $orderDetails->items->count() }} ) </span>
        </h3>
        <ul class="divide-y divide-border">
            @foreach ($orderDetails->items as $orderItem )
            <li>
                <div class="py-4 sm:py-6">
                    <div class="grid grid-cols-2 items-center justify-start gap-2 xs:grid-cols-3 xs:gap-6 sm:grid-cols-4 xl:grid-cols-6">
                        <div class="row-span-2 min-w-fit xs:mx-auto">
                            <a href="{{ route('product.details' , $orderItem->item->slug) }}">
                                <img src="{{ $orderItem->item->brand_img ?? ''}}" alt="{{ $orderItem->item->title ?? '' }}" class="h-25 w-25 rounded-lg object-cover sm:h-28 sm:w-28" />
                            </a>
                        </div>
                        <div class="row-span-2 space-y-3 xs:col-span-2 sm:col-span-3 xl:col-span-5">
                            <a href="{{ route('product.details' , $orderItem->item->slug) }}" class="line-clamp-2 text-sm md:text-base">{{ $orderItem->item->title ?? '' }}</a>
                            <div class="flex flex-col gap-2">
                                <!-- <div class="flex items-center gap-2">
                                    <div class="flex items-center gap-2">
                                        <div>سایز</div>
                                        <div>
                                            <div>44</div>
                                        </div>
                                    </div>
                                </div>
                                <div class="flex items-center gap-2">
                                    <div>رنگ</div>
                                    <div>
                                        <div class="h-6 w-6 rounded-full border-2" style="background-color: green"></div>
                                    </div>
                                </div> -->
                            </div>
                        </div>
                        <div class="flex items-center gap-x-2 xs:justify-center">
                            <div class="flex h-10 w-24 items-center justify-center gap-x-3 rounded-lg border px-4 py-1 sm:w-28">
                                <div class="flex h-5 w-5 select-none items-center justify-center text-sm font-medium sm:h-6 sm:w-6 sm:text-lg">
                                    {{ $orderItem->count }}
                                </div>
                            </div>
                        </div>
                        <div class="row-span-2 xs:col-span-2 sm:col-span-3 xl:col-span-5">
                            <del class="flex items-center gap-1 text-sm text-warning xs:col-span-2 sm:col-span-3 lg:text-lg xl:col-span-5">
                                {{ number_format($orderItem->price + $orderItem->discount) }}
                                {{ getCurrency() }}
                            </del>
                            <div class="flex items-center gap-1 text-primary xs:col-span-2 sm:col-span-3 lg:text-lg xl:col-span-5">
                                <span class="font-bold">{{ number_format($orderItem->price) }}</span>
                                <span class="text-sm lg:text-base">{{ getCurrency() }}</span>
                            </div>
                        </div>
                    </div>
                </div>
            </li>
            @endforeach
        </ul>

    </div>

    @endif
</div>
