<!-- resources/views/categories/partials/category.blade.php -->
<li class="list-group-item  list-hover-cat-parent">
    <div class="d-flex justify-content-between">
        <div>
            <img class="list-item-image" src="{{asset("uploads/$category->image")}}" alt="" style="width: 25px; aspect-ratio: 1/1;">
            {{ $category->name }}
        </div>
        <div class="d-flex align-items-center gap-3">
            <a class="badge bg-primary badge-pill " href="{{route('admin.categories.show' ,$category->id)}}">
                {{ __('details') }}
            </a>
            <a class="badge bg-primary badge-pill click-load" href="{{route('admin.categories.edit' ,$category->id)}}">
                {{ __('edit') }}
            </a>
            <a class="badge bg-primary badge-pill click-load" href="{{route('admin.category.attribute.index' ,$category->id)}}">
                {{ __('attribute') }}
            </a>
            @if($category->children->isEmpty())
            <a class="badge bg-primary badge-pill click-load" href="{{route('admin.product.create' ,['category_id' => $category->id])}}">
                {{ __('create a product') }}
            </a>
            @endif

            <form class="m-0 p-0 d-inline-block delete-form" action="{{ route('admin.categories.destroy' , $category->id) }}"  method="post" onsubmit="return confirm('<?php echo __('Are you sure you want to delete this coupon?') ?>');">
                @method('DELETE')
                @csrf
                <button class="badge bg-danger badge-pill border-0">
                    {{ __('delete') }}
                </button>
            </form>
        </div>
    </div>

    @if($category->children->isNotEmpty())

    <ul class="list-group mb-3 mt-3">
        @foreach($category->children as $child)
        @include('pages.admin.categories.partials.categories', ['category' => $child])
        @endforeach
    </ul>
    @endif
</li>
