@extends('layouts.syndron.app')

@section('content')

<div class="card">
    <div class="card-body">
        <x-syndron.ui.table :columns="['ID','Provider ID','Slot ID','Status','Tracking Code','Created At','Actions']">
            @foreach($deliveries as $delivery)
            <tr>
                <td>{{ $delivery->id }}</td>
                <td>{{ $delivery->provider_id }}</td>
                <td>{{ $delivery->slot_id }}</td>
                <td>{{ $delivery->status }}</td>
                <td>{{ $delivery->tracking_code }}</td>
                <td>{{ $delivery->created_at }}</td>
                <td>

                    @can('delivery.view')
                    <a href="{{ route('admin.delivery.deliveries.show', $delivery) }}" class="btn btn-info btn-sm">{{ __('View') }}</a>
                    @endcan

                    @can('delivery.edit')
                    <a href="{{ route('admin.delivery.deliveries.edit', $delivery) }}" class="btn btn-warning btn-sm">{{ __('Edit') }}</a>
                    @endcan

                    @can('delivery.delete')
                    <form action="{{ route('admin.delivery.deliveries.destroy', $delivery) }}" method="POST" style="display:inline-block;">
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('<?php echo __('Are you sure?'); ?>')">{{ __('Delete') }}</button>
                    </form>
                    @endcan
                </td>
            </tr>
            @endforeach
        </x-syndron.ui.table>
    </div>
</div>
@endsection
