@extends('layouts.syndron.app')

@section('content')

<div class="card">
    <div class="card-header d-flex justify-content-between">
        <div>
            <h4>
                {{ __('Flagged FAQ Items') }}
            </h4>
        </div>
    </div>

    <div class="card-body">
        <x-syndron.ui.table :columns="['ID', 'User','Question', 'Reason', 'Flagged Item','Delete Item', 'Created At']">
            @forelse($flags as $flag)
            <tr>
                <td>{{ $flag->id }}</td>
                <td>{{ $flag->user ? $flag->user->name : 'N/A' }}</td>
                <td>
                    <a href="{{ route('admin.faq.questions.show', $flag->flaggable->question_id) }}">
                        {{ __('Question Details') }}
                    </a>
                </td>
                <td>{{ $flag->reason }}</td>
                <td>
                    @if($flag->flaggable)
                    <p>
                        {{ $flag->flaggable->user?->name ?? 'N/A' }}:
                        {{ $flag->flaggable->body ?? 'N/A' }}
                    </p>
                    @else
                    N/A
                    @endif
                </td>
                <td>
                    @can('faq.flag.delete')
                    <form action="{{ route('admin.faq.flags.destroy', $flag->id) }}" method="post">
                        @csrf
                        <button type="submit" class="btn btn-danger btn-sm">{{ __('Delete') }}</button>
                    </form>
                    @endcan
                </td>
                <td>{{ $flag->created_at }}</td>
            </tr>
            @empty
            <tr>
                <td colspan="7">{{ __('No flags found.') }}</td>
            </tr>
            @endforelse
        </x-syndron.ui.table>
    </div>
</div>
@endsection
