@extends('layouts.syndron.app')
@section('content')
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <div class="d-flex justify-content-between">
                            <h3 class="header-title">
                                {{ __('site options') }}
                            </h3>
                            <div class="">
                                <a href="{{ route('admin.option.create' , ['group' => $_GET['group'] ?? '' ]) }}" class="btn btn-primary"> {{ __('Add new option') }} </a>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">

                        <table class="table table-striped table-bordered text-center align-middle">
                            <thead>
                                <tr>
                                    <th>{{ __('#') }}</th>
                                    <th>{{ __('Key') }}</th>
                                    <th>{{ __('Value') }}</th>
                                    <th>{{ __('Actions') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($siteOptions as $option)
                                <tr>
                                    <td>{{ $loop->iteration }}</td>
                                    <td>{{ $option->key }}</td>
                                    @if (is_string_link($option->value))
                                    <td><img src="{{ asset("uploads/$option->value") }}" alt="" style="height: 50px; max-width:150px;"></td>
                                    @else
                                    <td>{{ $option->value }}</td>
                                    @endif
                                    <td>
                                        <div class="dropdown">
                                            <div class="btn-group">
                                                <button type="button" class="btn btn-secondary dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false"> {{ __('Actions') }} <i class="mdi mdi-chevron-down"></i> </button>
                                                <div class="dropdown-menu">
                                                    <a class="dropdown-item" href="{{ route('admin.option.show', $option->id) }}">{{ __('Show') }}</a>
                                                    <a class="dropdown-item" href="{{ route('admin.option.edit', $option->id) }}">{{ __('Edit') }}</a>
                                                    <form action="{{ route('admin.option.destroy', $option->id) }}" method="POST" style="display: inline;">
                                                        @csrf
                                                        @method('DELETE')
                                                        <button type="submit" class="dropdown-item">{{ __('Delete') }}</button>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>

                    </div> <!-- end card-body -->
                </div> <!-- end card-->
            </div> <!-- end col -->
        </div>
@endsection
