@extends('layouts.syndron.app')

@section('content')
<div class="card">
    <div class="card-header">
        <h4>{{ $page->title }}</h4>
    </div>
    <div class="card-body">
        <div class="mb-3">
            <strong>{{ __('Slug') }}:</strong> {{ $page->slug }}
        </div>
        <div class="mb-3">
            <strong>{{ __('Status') }}:</strong> {{ ucfirst($page->status) }}
        </div>
        <div class="mb-3">
            <strong>{{ __('Author') }}:</strong> {{ $page->author?->name ?? '-' }}
        </div>
        <div class="mb-3">
            <strong>{{ __('Content') }}:</strong>
            <div>{!! $page->content !!}</div>
        </div>
        <div class="mb-3">
            <strong>{{ __('Excerpt') }}:</strong> {{ $page->excerpt }}
        </div>
        <div class="mb-3">
            <strong>{{ __('Meta Title') }}:</strong> {{ $page->meta_title }}
        </div>
        <div class="mb-3">
            <strong>{{ __('Meta Description') }}:</strong> {{ $page->meta_description }}
        </div>
        <div class="mb-3">
            <strong>{{ __('Meta Keywords') }}:</strong> {{ $page->meta_keywords }}
        </div>
        <div class="mb-3">
            <strong>{{ __('Template') }}:</strong> {{ $page->template }}
        </div>
        <div class="mb-3">
            <strong>{{ __('Featured Image') }}:</strong>
            @if($page->featured_image)
            <img src="{{ asset('uploads/' . $page->featured_image) }}" class="img-thumbnail" style="max-height: 150px;">
            @else
            <span>-</span>
            @endif
        </div>
        <div class="mb-3">
            <strong>{{ __('Position') }}:</strong> {{ $page->position }}
        </div>
        <div class="mb-3">
            <strong>{{ __('Published At') }}:</strong> {{ $page->published_at }}
        </div>
    </div>
</div>
@endsection
