@extends('layouts.syndron.app')

@section('content')


@if (!Route::is('admin.shop.product-selection'))
<div class="d-flex gap-2 mb-2 pb-3 border-bottom">
    <a class="btn btn-primary btn-sm" href="{{ route('admin.product.index' , ['show' => 'list']) }}">نمایش به صورت لیست</a>
    <a class="btn btn-primary btn-sm" href="{{ route('admin.product.index' , ['show' => 'grid']) }}">نمایش به صورت گرید</a>
</div>
@endif
@if (!isset($_GET['show']) || $_GET['show'] === 'list')
<div>
    <x-syndron.ui.table :columns="['Image', 'Title', 'Code', 'Price','Price With Discount','Off Rate', 'Status', 'Actions']">
        @forelse ($products as $product)
        <tr>
            <td><img src="{{ $product->brand_img }}" class="img-thumbnail square-box" style="height: 80px;" alt="{{ $product->title }}"></td>
            <td>{{ $product->title }}</td>
            <td>{{ $product->code }}</td>
            <td>{{ number_format($product->price) }}</td>
            <td>{{ number_format($product->discount_price) }}</td>
            <td>{{ $product->off_rate }}%</td>
            <td>
                {{ __($product->status) }}
            </td>
            <td>
                <div class="d-flex flex-wrap justify-content-center align-items-center gap-1">
                    @can('product.add.inventory')
                    <div class="w-100">
                        <a class="btn btn-primary btn-sm" href="{{ route('admin.shop.add.inventory', $product->id) }}">{{ __('i want to sell this product too') }}</a>
                    </div>
                    @endcan
                    @can('product.show')
                    <a class="btn btn-primary btn-sm" href="{{ route('admin.product.show', $product->id) }}">{{ __('Show') }}</a>
                    @endcan
                    @can( 'product.edit')
                    <a class="btn btn-warning btn-sm" href="{{ route('admin.product.edit', $product->id) }}">{{ __('Edit') }}</a>
                    @endcan
                    @can('product.delete')
                    <form action="{{ route('admin.product.destroy', $product->id) }}" method="POST" onsubmit="return confirm('<?php echo  __('Are you sure you want to delete this product?'); ?>');">
                        @csrf
                        @method('DELETE')
                        <button class="btn btn-danger btn-sm" type="submit">{{ __('Delete') }}</button>
                    </form>
                    @endcan
                </div>
            </td>
        </tr>
        @empty
        <tr>
            <td colspan="5" class="text-center">{{ __('No products found.') }}</td>
        </tr>
        @endforelse
    </x-syndron.ui.table>
</div>
@endif
@if (isset($_GET['show']) && $_GET['show'] == 'grid')
<div class="row row-cols-1 row-cols-sm-2 row-cols-lg-3 row-cols-xl-4 row-cols-xxl-5 product-grid">
    @forelse ($products as $product )
    <div class="col">
        <x-syndron.ui.product-card :product="$product" />
    </div>
    @empty
    @endforelse
</div>

@endif
{{ $products->links() }}
@endsection
